<?php


class Connect extends PDO{

    private $host = "localhost";
    private $dbName = "mediacen_sib";
    private $userName = "mediacen_sib";
    private $passUser = 'z+bx*[~M0#d,';

    private $conn;

    //conecta no banco
    public function __construct(){
        $this->conn = new PDO("mysql:host=$this->host;dbname=$this->dbName", $this->userName, $this->passUser);
        $this->conn->exec("set names utf8");
    }

    //executa no banco
    public function query($rawQUery, $params = array()){
        $stmt = $this->conn->prepare($rawQUery);
        $this->setParams($stmt, $params);
        $stmt->execute();
        return $stmt;
    }

    //insert and get last ID
    public function queryAndLastID($rawQUery, $params = array()){
        $stmt = $this->conn->prepare($rawQUery);
        $this->setParams($stmt, $params);
        $stmt->execute();
        $lastId = $this->conn->lastInsertId();
        return $lastId;
    }

    //executa no banco e retorna true or false
    public function queryReturn($rawQUery, $params = array()){
        $stmt = $this->conn->prepare($rawQUery);
        $this->setParams($stmt, $params);
        $res = $stmt->execute();
        return $res;
    }

    //delete and return affected rows
    public function queryAffectedRows($rawQUery, $params = array()){
        $stmt = $this->conn->prepare($rawQUery);
        $this->setParams($stmt, $params);
        $stmt->execute();
        $count = $stmt->rowCount();
        return $count;
    }

    //seta os parametros na bind
    private function setParams($statment, $parameters = array() ){
        foreach($parameters as $key => $value){
            $this->setParam($statment, $key, $value);
        }
    }

    //executa a bind
    private function setParam($statment, $key, $value){
        $statment->bindParam($key, $value);
    }

    //select na tabela
    public function select($rawQuery, $params = array()){
        $stmt = $this->query($rawQuery, $params);
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $results;
    }

    //monta array
    public function authQuery($table, $action, $arr = array(), $type = 'text', $param = null, $valueParam = null)
    {
        $query = null;
        $arrFields = null;
        $arrValues = array();
        $arrMask = null;
        $arrUpdate  = null;


        $a = 0;
        foreach ($arr as $key => $value){
            $arrFields .= $key.", ";
            $arrMask .= ":V$a, ";
            $arrUpdate .= "$key = :V$a, ";

            if($type === 'number')
                $arrValues[":V$a"] = str_replace(",",".",$value);

            if($type === 'text')
                $arrValues[":V$a"] = $value;

            $a++;
        }

        $arrFields = rtrim($arrFields,", ");
        $arrMask = rtrim($arrMask,", ");
        $arrUpdate = rtrim($arrUpdate,", ");


        $res = null;
        if($action === "insert"){
            $query = "insert into $table ($arrFields) values ($arrMask) ";
            $res = $this->queryReturn($query, $arrValues);
        }


        if($action === "insert-return-id"){
            $query = "insert into $table ($arrFields) values ($arrMask) ";
            $res = $this->queryAndLastID($query, $arrValues);
        }


        if($action === "update"){
            $query = "update $table set $arrUpdate where $param = $valueParam ";
            $res = $this->queryReturn($query, $arrValues);
        }


        return $res;
    }
}