<?php
session_set_cookie_params(12000);
session_start();

#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### SCOMPA - DEPENDENCIAS
#---------------------------------------------------------------------------------------------------------------------------------------------------#



#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### CREDITOS
#---------------------------------------------------------------------------------------------------------------------------------------------------#
$versao_sistema = "1.0";
$programmer = "Danilo Robson Ribeiro";
$programmer_company = "Codetek";
$programmer_mail = "d.r.ribeiro@outlook.com";
$programador_obs = "Não há nada mais trabalhoso do que viver sem trabalhar!";


#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### ALTERAR EM MIM TB
#---------------------------------------------------------------------------------------------------------------------------------------------------#

error_reporting("E_ERRORS");
ini_set("display_errors", 0 );
date_default_timezone_set('America/Sao_Paulo');

$nomepasta = "sistema";
$hoje_data = date("Y-m-d");

#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### INCLUDES
#---------------------------------------------------------------------------------------------------------------------------------------------------#
include("/".$_SERVER['DOCUMENT_ROOT']."/$nomepasta/classes/config.php");
#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### FUNCOES ANTIGAS
#---------------------------------------------------------------------------------------------------------------------------------------------------#

### MUDA A DATA NO FORMATO AAAA-MM-DD para DD/MM/AAAA
function mudaData($data){
    $data_part = explode("-",$data) ;
    $barra = "/" ;
    $newdata = $data_part[2].$barra.$data_part[1].$barra.$data_part[0] ;
    return $newdata ;
}
### MUDA A DATA NO FORMATO DD/MM/AAAA  para AAAA-MM-DD
function voltarData($data){
    $data_part = explode("/",$data) ;
    $barra = "-" ;
    $newdata = $data_part[2].$barra.$data_part[1].$barra.$data_part[0] ;
    return $newdata ;
}
### ANTIGA FUNCAO DE EXECUCAO EM BANCO
function mysqlexecuta($id,$sql) {
    $con = new Conexao();
    return $con->myexec($sql);
}

#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### CLASSES
#---------------------------------------------------------------------------------------------------------------------------------------------------#


##################################################### FERRAMENTAS
class Tools {
    //completa line
    public function showMeLine($parthshow) {

        $comp = "";
        $pat_retorno = $parthshow;
        $qtd_cara = (int) strlen($parthshow);
        $qtd_falta = ((int)(60-$qtd_cara));
        for($i=0;$i<$qtd_falta;$i++)
            $comp = $comp."...";
        return $pat_retorno.$comp;
    }

    //gera senha
    function geraSenha($tamanho = 40, $maiusculas = true, $numeros = true, $simbolos = false)
    {
        $lmin = 'abcdefghijklmnopqrstuvwxyz';
        $lmai = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $num = '1234567890';
        $simb = '!@#$%*-';

        $retorno = '';
        $caracteres = '';

        $caracteres .= $lmin;
        if ($maiusculas) $caracteres .= $lmai;
        if ($numeros) $caracteres .= $num;
        if ($simbolos) $caracteres .= $simb;
        $len = strlen($caracteres);
        for ($n = 1; $n <= $tamanho; $n++) {

            $rand = mt_rand(1, $len);

            $retorno .= $caracteres[$rand-1];
        }

        return $retorno;
    }
    ################ tras strip
    function strip_html_tags( $text )
    {

        $text = utf8_encode($text);
        $text = preg_replace(
            array(
                // Remove invisible content
                '@<head[^>]*?>.*?</head>@siu',
                '@<style[^>]*?>.*?</style>@siu',
                '@<script[^>]*?.*?</script>@siu',
                '@<object[^>]*?.*?</object>@siu',
                '@<embed[^>]*?.*?</embed>@siu',
                '@<applet[^>]*?.*?</applet>@siu',
                '@<noframes[^>]*?.*?</noframes>@siu',
                '@<noscript[^>]*?.*?</noscript>@siu',
                '@<noembed[^>]*?.*?</noembed>@siu',
                '@<META[^>]*?.*?</META>@siu',
                '@<meta[^>]*?.*?</meta>@siu',
                '@<META[^>]*?.*?>@siu',
                // Add line breaks before and after blocks
                '@</?((address)|(blockquote)|(center)|(del))@iu',
                '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
                '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
                '@</?((table)|(th)|(td)|(caption))@iu',
                '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
                '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
                '@</?((frameset)|(frame)|(iframe) |(META))@iu',
            ),
            array(
                ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
                "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0",
                "\n\$0", "\n\$0",
            ),
            $text );

        $text = ereg_replace("[^a-zA-Z0-9_]", "", strtr($text, "áàãâéêíóôõúüçÁÀÃÂÉÊÍÓÔÕÚÜÇ'\"`´^?%$#@!", "aaaaeeiooouucAAAAEEIOOOUUC           "));

        return strip_tags( $text );
    }
    ################### AJUSTA LEtras para tabela
    function ajusName($name) {
        $letrasatrocar = array('á','é','í','ó','ú','ã','õ','ê','ô','ç','Á','É','Í','Ó','Ú','Ã','Õ','Ê','Ô','Ç','&','?','(',')','*','&','%','$','#','@','!','<','>','/','+','º','.','-',' ') ;
        $letrastrocadas =  array('a','e','i','o','u','a','o','e','o','c','A','E','I','O','U','A','O','E','O','C',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','','','','','','','') ;

        $letrasminusculinhas = array('á','é','í','ó','ú','ã','õ','ê','ô','ç','Á','É','Í','Ó','Ú','Ã','Õ','Ê','Ô','Ç','&','?','(',')','*','&','%','$','#','@','!','<','>','/','+',' ',',') ;
        $letrasmaiusculinhas =  array('a','e','i','o','u','a','o','e','o','c','A','E','I','O','U','A','O','E','O','C','','','','','','','','','','','','','','','','','') ;

        $name = str_replace($letrasatrocar,$letrastrocadas,$name);
        $name = str_replace($letrasminusculinhas,$letrasmaiusculinhas,$name);
        $name = strtolower($name);

        return $name;

    }
    function ajustaNameFile($name) {
        $letrasatrocar = array('á','é','í','ó','ú','ã','õ','ê','ô','ç','Á','É','Í','Ó','Ú','Ã','Õ','Ê','Ô','Ç','&','?','(',')','*','&','%','$','#','@','!','<','>','/','+','º','%','-',' ') ;
        $letrastrocadas =  array('a','e','i','o','u','a','o','e','o','c','A','E','I','O','U','A','O','E','O','C',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','','','','','','','') ;

        $letrasminusculinhas = array('á','é','í','ó','ú','ã','õ','ê','ô','ç','Á','É','Í','Ó','Ú','Ã','Õ','Ê','Ô','Ç','&','?','(',')','*','&','%','$','#','@','!','<','>','/','+',' ',',') ;
        $letrasmaiusculinhas =  array('a','e','i','o','u','a','o','e','o','c','A','E','I','O','U','A','O','E','O','C','','','','','','','','','','','','','','','','','') ;

        $name = str_replace($letrasatrocar,$letrastrocadas,$name);
        $name = str_replace($letrasminusculinhas,$letrasmaiusculinhas,$name);
        $name = strtolower($name);

        return $name;

    }
    ################### GET ICONE
    function ico($idico,$size) {
        $conx = new Conexao();
        $bb = $conx->myexec("SELECT * from parametros_icones where  idicones = '$idico'");
        while($lnxa = mysql_fetch_array($bb)) {
            return  "<i class=\"$lnxa[icone] $size \"></i>" ;
        }
    }
    ################## STRING PARA BUSCA
    public function  stringParaBusca($str) {
        //Transformando tudo em minúsculas
        $str = trim(strtolower($str));
        //Tirando espaços extras da string... "tarcila  almeida" ou "tarcila   almeida" viram "tarcila almeida"
        while ( strpos($str,"  ") )
            $str = str_replace("  "," ",$str);
        //Agora, vamos trocar os caracteres perigosos "ã,á..." por coisas limpas "a"
        $caracteresPerigosos = array ("Ã","ã","Õ","õ","á","Á","é","É","í","Í","ó","Ó","ú","Ú","ç","Ç","à","À","è","È","ì","Ì","ò","Ò","ù","Ù","ä","Ä","ë","Ë","ï","Ï","ö","Ö","ü","Ü","Â","Ê","Î","Ô","Û","â","ê","î","ô","û","!","?");
        $caracteresLimpos    = array ("a","a","o","o","a","a","e","e","i","i","o","o","u","u","c","c","a","a","e","e","i","i","o","o","u","u","a","a","e","e","i","i","o","o","u","u","A","E","I","O","U","a","e","i","o","u",".",".",".",".",".",".","." ,"." ,".");
        $str = str_replace($caracteresPerigosos,$caracteresLimpos,$str);
        //Agora que não temos mais nenhum acento em nossa string, e estamos com ela toda em "lower",
        //vamos montar a expressão regular para o MySQL
        $caractresSimples = array("a","e","i","o","u","c");
        $caractresEnvelopados = array("[a]","[e]","[i]","[o]","[u]","[c]");
        $str = str_replace($caractresSimples,$caractresEnvelopados,$str);
        $caracteresParaRegExp = array(
            "(a|ã|á|à|ä|â|&atilde;|&aacute;|&agrave;|&auml;|&acirc;|Ã|Á|À|Ä|Â|&Atilde;|&Aacute;|&Agrave;|&Auml;|&Acirc;)",
            "(e|é|è|ë|ê|&eacute;|&egrave;|&euml;|&ecirc;|É|È|Ë|Ê|&Eacute;|&Egrave;|&Euml;|&Ecirc;)",
            "(i|í|ì|ï|î|&iacute;|&igrave;|&iuml;|&icirc;|Í|Ì|Ï|Î|&Iacute;|&Igrave;|&Iuml;|&Icirc;)",
            "(o|õ|ó|ò|ö|ô|&otilde;|&oacute;|&ograve;|&ouml;|&ocirc;|Õ|Ó|Ò|Ö|Ô|&Otilde;|&Oacute;|&Ograve;|&Ouml;|&Ocirc;)",
            "(u|ú|ù|ü|û|&uacute;|&ugrave;|&uuml;|&ucirc;|Ú|Ù|Ü|Û|&Uacute;|&Ugrave;|&Uuml;|&Ucirc;)",
            "(c|ç|Ç|&ccedil;|&Ccedil;)" );
        $str = str_replace($caractresEnvelopados,$caracteresParaRegExp,$str);
        //Trocando espaços por .*
        $str = str_replace(" ",".*",$str);
        //Retornando a String finalizada!
        return $str;
    }

}
##################################################### CONEXAO
class Conexao extends  Tools
{
    //tacar dados no session
    public function DefinirVarSessions($usuario_sys,$password_sys,$link_sys,$userftp_sys,$senhaftp_sys,$linkftp_sys) {

        $_SESSION[usuario_sys]  = $usuario_sys;
        $_SESSION[password_sys] = $password_sys;
        $_SESSION[link_sys] = $link_sys;
        $_SESSION[userftp_sys] = $userftp_sys;
        $_SESSION[senhaftp_sys] = $senhaftp_sys;
        $_SESSION[linkftp_sys] = $linkftp_sys;

    }

    //define banco de dados
    public function DefinirDB($dbname) {
        $_SESSION[dbname_sys] = "mediacen_sip";
    }

    //definie conexao
    public function DefinirConexao()
    {
        $this->usuario =  'mediacen_sib';
        $this->password = 'z+bx*[~M0#d,';
        $this->link = 'localhost';
        $this->dbname = 'mediacen_sib';
        $this->userftp = '';
        $this->senhaftp = $_SESSION[senhaftp_sys];
        $this->linkftp = $_SESSION[linkftp_sys];
    }

    public function returnConec($name) {
        $this->DefinirConexao();
        return $this->$name;
    }


    //gera log
    public function logMe($log)
    {
        $this->exeQuery("INSERT into log_er VALUES ( NULL , '$log' , NULL)");
    }
    //busca em banco e retorna fech
    public function myexec($query)
    {
        $this->DefinirConexao();
        if (!($id = mysql_connect($this->link, $this->usuario, $this->password))) {
            return "Falha na conexão";
        } else {
            if (!empty($this->dbname)) {
                if (!($con = mysql_select_db($this->dbname, $id))) {
                    mysql_close($id);
                    return "Falha ao selecionar banco de dados";
                }
                else {
                    if (empty($query)) {
                        mysql_close($id);
                        return "Query Vazia";
                    } else {
                        if (!($res = @mysql_query($query, $id))) {
                            mysql_close($id);
                            return "Erro ao executar a query";
                        }
                        else {
                            mysql_close($id);
                            return $res;
                        }
                    }
                }
            } else {
                mysql_close($id);
                return "Falha, banco de dados vazio";
            }
        }

    }
    //busca dado unico em query
    public function simpleExec($query = "alias lookingfor") {
        $bb = $this->myexec("$query");
        while($ln_d = mysql_fetch_array($bb)) {
            return $ln_d[lookingfor];
        }
    }
    //executa em banco e retorna bolean
    public function exeQuery($query)
    {
        $this->DefinirConexao();
        if (!($id = mysql_connect($this->link, $this->usuario, $this->password)))
            return "Falha na conexão";
        if (!($con = mysql_select_db($this->dbname, $id)))
            return "Falha ao selecionar banco de dados";
        if (empty($query))
            return "Query Vazia";
        if (!($res = @mysql_query($query, $id)))
            return false;
        else
            return true;
        mysql_close($id);
    }
    //retorna qtd de dados
    public function numQuery($query)
    {
        $falha = $this->DefinirConexao();
        if (!($id = mysql_connect($this->link, $this->usuario, $this->password)))
            return "Falha na conexao " . $falha;
        if (!($con = mysql_select_db($this->dbname, $id)))
            return "Falha ao selecionar banco de dados " . $falha;
        if (empty($query))
            return "Query Vazia";
        if (!($res = @mysql_query($query, $id)))
            return 0;
        else
            return mysql_num_rows($res);
        mysql_close($id);
    }
    //Retorna proximo do auto-incremet
    public function getNext($tabela)
    {
        $resultado = $this->myexec("SHOW TABLE STATUS LIKE '$tabela'");
        $linha = mysql_fetch_array($resultado);
        $newcode = $linha['Auto_increment'];
        return $newcode;
    }
    //tras valor
    public function getVal($tabela,$campo,$referencia,$valor){
        $resultado = $this->myexec("SELECT $campo as valor from $tabela where $referencia = '$valor'");
        $dados = mysql_fetch_array($resultado);
        return $dados[valor] ;
    }
    ################## GERT PAR
    public function getPar($idpar)
    {
        return $this->getVal('parametros','par_valor','id_parametros',$idpar);
    }
    ################ valores a partir de select
    public function trasValue($idpartable,$idedita,$parametro,$idtabela) {

        $conexao = new Conexao();

        if(empty($idedita)) {
            return "" ;
        } else {
            $tras_autocomplete = $conexao->myexec("SELECT * from parametros_tabelas where idpar_table = '$idpartable' ");
            while($lncomplet = mysql_fetch_array($tras_autocomplete)) {
                $opcoes_complete = explode("@",$lncomplet[parametros_autocomplete]) ;

                if($parametro == "valor") {
                    $tras_data = $conexao->myexec("SELECT $lncomplet[nometablecoluna]  as valor from $lncomplet[nometable] where $idtabela = '$idedita'") ;
                    while($lnres = mysql_fetch_array($tras_data)){
                        if($lncomplet[field_type] == 'DATE')
                            return mudaData($lnres[valor]) ;
                        else
                            return $lnres[valor] ;
                    }

                }
                else
                {
                    $tras_data = $conexao->myexec("SELECT $lncomplet[nometablecoluna]  as valor from $lncomplet[nometable] where $idtabela = '$idedita'" ) ;
                    while($lnres = mysql_fetch_array($tras_data)){
                        $valor = $lnres[valor] ;
                    }

                    if($lncomplet[tipo_campo] == "selecteslave") {

                        $opcoes_select = explode("@",$lncomplet[opcoes_camposelect]) ;
                        $query = "SELECT * from $opcoes_select[1] where  $opcoes_select[2] = '$valor'" ;
                        $res_item = $conexao->myexec($query) ;
                        while($ln_select = mysql_fetch_array($res_item)){
                            return  $ln_select[$opcoes_select[3]] ;
                        }

                    } else {
                        if($lncomplet[tipo_campo] == "selecte_slave_slave") {

                            $opcoes_select = explode("@",$lncomplet[opcoes_camposelect]) ;
                            $query = "SELECT * from $opcoes_select[1] where  $opcoes_select[2] = '$valor'" ;
                            $res_item = $conexao->myexec($query) ;
                            while($ln_select = mysql_fetch_array($res_item)){
                                return  $ln_select[$opcoes_select[3]] ;
                            }
                        } else {

                            $opcoes_select = explode("@",$lncomplet[opcoes_camposelect]) ;
                            $query = "SELECT * from $opcoes_select[0] where  $opcoes_select[1] = '$valor'" ;
                            $res_item = $conexao->myexec($query) ;
                            while($ln_select = mysql_fetch_array($res_item)){
                                return  $ln_select[$opcoes_select[2]] ;
                            }
                        }
                    }

                }
            }
        }
    }
    ################ OUTRA FUNCAO FELIZ DE TRAS VALOR PARA SELECTS
    public function trasValueOther($idpartable,$idedita,$parametro,$idtabela) {

        $con = new Conexao();

        $tras_autocomplete = $con->myexec("SELECT * from parametros_tabelas where idpar_table = '$idpartable' ") ;
        while($lncomplet = mysql_fetch_array($tras_autocomplete)) {

            $opcoes_complete = explode("@",$lncomplet[parametros_autocomplete]) ;
            $tras_data = $con->myexec("SELECT $lncomplet[nometablecoluna]  as valor from $lncomplet[nometable] where $idtabela = '$idedita'") ;
            while($lnres = mysql_fetch_array($tras_data)){
                $valor = $lnres[valor] ;
            }
            $opcoes_select = explode("@",$lncomplet[opcoes_camposelect]) ;
            $res_item = $con->myexec("SELECT * from $opcoes_select[1] where  $opcoes_select[2] = '$valor'") ;
            while($ln_select = mysql_fetch_array($res_item)){
                return  $ln_select[$opcoes_select[0]] ;
            }
        }

    }
}

##################################################### IDIOMA
class Language extends Conexao {
    public function definiArray() {
        $par =  $this->getPar(1) ;
        if(empty($par))
            $par = 0;
        ########### arrays
        ## PT-BR 1
        $array_pt = array(
            "Pluto",
            "Acessar",
            "Esqueceu a senha?",
            "Clique aqui",
            "Você parece ter perdido sua conexão com a internet! <br > Certifique-se de que esta conectado para que não perca os dados desta página.",
            "Tentando novamente em ",
            "Usuário ou senha inválidos",
            "Sair",
            "Perfil",
            "Carregando...",
            "Configurações", //10
            "Acesso negado", //11
            "Salvar",  //12
            "Cancelar" , //13
            "N/A",  //14
            "Digite para pesquisar...", //15
            "Nenhum resultado encontrado", //16
            "Envie um ou mais arquivos ou um  .zip com os arquivos dentro.", //17
            "Salvar e Recortar", //18
            "Salvar, Recortar e redimensionar para ", //19
            "Salvar sem recortar ", //20
            "Apenas redimensionar para largura de ", //21
            "Extrair", //22
            "Deseja realmente sair sem salvar? irá perder tudo", //23
            "Redirecionando.... aguarde.", //24
            "Filtro", //25
            "Resultados", //26
            "Trazendo resultados com ", //27
            "Trazendo página ", //28
            "Quantidade de paginas  ", //29
            "Quantidade de registros ", //30
            "Ações", //31
            "Pesquisar" ,//32
            "Registros por página", //33
            "Usuários",//34
            "Nome", //35
            "Nivel", //36
            "Cadastrar/Editar Usuário", //37
            "Niveis de acesso", //38
            "Cadastrar/Editar Nivel", //39
            "Funções", //40
            "Cadastrar/Editar Função", //41
            "Permissoes Adicionadas", //42
            "Adicionar permissão", //43
            "Edição do menu", //44
            "Configurações", //45
            "Link", //46
            "" //
        );

        $array_eng = array("Login","Acessar","Esqueceu sua senha","Você parece ter perdido sua conexão com a internet! <br > Certifique-se de que esta conectado para que não perca os dados desta página.");

        $array_todas = array($array_pt,$array_eng);
        return $array_todas[$par];
    }
    public function lM($campo) {
        return $this->definiArray()[$campo];
    }
}
##################################################### CLASS ACESSO
class Acessos  extends Conexao {

    //funcao grava acesso
    public function gravaAcesso($tipo) {
        $con = new Conexao();
        $ip = $_SERVER["REMOTE_ADDR"];
        $con->exeQuery("INSERT into acessos VALUES ( NULL , NULL , '$ip' , '$tipo')");
    }
    //essa funcao efetua o login
    public function efetuarLogin($login,$senha,$retorno) {
        $senha = md5(addslashes($senha));
        $login = addslashes($login);

        $expire = time() + 60*60*1*$this->getPar(2); //5 horas.

        $sql_busca = "SELECT * from usuarios, parametros_niveis where usu_nivel = id_niveis and usu_login = '$login' and usu_senha = '$senha' and usu_status = 'ATIVADO'";
        $this->logMe("$login   $senha");

        $busca = $this->myexec($sql_busca);
        $qtd_conf = mysql_num_rows($busca);

        while($ln_dd = mysql_fetch_array($busca))
        {
            $show_filed = $this->myexec("Show Fields from usuarios");
            while($ln_us = mysql_fetch_array($show_filed)) {
                setcookie("$ln_us[Field]",$ln_dd[$ln_us[Field]],$expire,"/");
                $_SESSION[$ln_us['Field']] = $ln_dd[$ln_us['Field']];
            }
            setcookie("menu_liberado",$ln_dd['menu_liberado'],$expire,"/");
            $_SESSION[menu_liberado] = $ln_dd['menu_liberado'];
        }

        if($retorno == '1') {
            if($qtd_conf > 0)
                return true;
            else
                return false;
        }

        if($retorno == '2') {
            return $busca;
        }

    }
    // LOGOUT
    public function sair(){
        $show_filed = $this->myexec("Show Fields from usuarios");
        while($ln_us = mysql_fetch_array($show_filed)) {
            $expire = time() + 60*60*1*5; //5 horas.
            setcookie("$ln_us[Field]","",$expire,"/");
        }
        $_SESSION[banco] = '';
    }
    //verifica se tem login
    public function isAlreadyLogin($par_start_path_sistema){
        $busca = $this->myexec("SELECT * from usuarios where usu_login = '$_COOKIE[usu_login]' and usu_senha = '$_COOKIE[usu_senha]' and usu_status = 'ATIVADO'");
        $qtd_conf = mysql_num_rows($busca);
        if($qtd_conf > 0)
            header("Location: ".$par_start_path_sistema."painel.php");
    }
    //verifica se esta logado
    //verifica se tem login
    public function isLogin($par_start_path_sistema){
        $busca = $this->myexec("SELECT * from usuarios where usu_login = '$_COOKIE[usu_login]' and usu_senha = '$_COOKIE[usu_senha]' and usu_status = 'ATIVADO'");
        $qtd_conf = mysql_num_rows($busca);
        if($qtd_conf == 0)
            header("Location: $par_start_path_sistema/index.php");
    }
    // verifica acesso
    public function isAcess($idtela) {
        $qtd_nivel = $this->numQuery("SELECT * from parametros_permissoes where codnivel = '$_COOKIE[usu_nivel]' and codfuncao = '$idtela'");
        if($qtd_nivel > 0)
            return true;
        else
            return false;

    }

}
##################################################### MANIPULACAO DE IMAGEM
/* CREDITOS START  hi@daviferreira.com @davitferreira */
class m2brimagem {

    // arquivos
    private $origem, $img, $img_temp;
    // dimensões
    private $largura, $altura, $nova_largura, $nova_altura, $tamanho_html;
    // dados do arquivo
    private $formato, $extensao, $tamanho, $arquivo, $diretorio;
    // extensões válidas
    private $extensoes_validas;
    // cor de fundo para preenchimento
    private $rgb;
    // posicionamento do crop
    private $posicao_crop;
    // mensagem de erro
    private $erro;

    /**
     * Construtor
     * @param $string caminho da imagem a ser carregada
     * @return void
     */
    public function m2brimagem( $origem = '', $extensoes_validas = array( 'jpg', 'jpeg', 'jpe', 'gif', 'bmp', 'png' ) )
    {

        $this->origem					= $origem;
        $this->extensoes_validas		= $extensoes_validas;

        if ( $this->origem )
        {
            $this->dados();
        }

        $this->rgb( 0, 0, 0 );

    } // fim construtor

    /**
     * Retorna dados da imagem
     * @param
     * @return void
     */
    private function dados()
    {

        // mensagem padrão, sem erro
        $this->erro = 'OK';

        // verifica se imagem existe
        if ( !is_file( $this->origem ) )
        {
            $this->erro = 'Erro: Arquivo de imagem não encontrado!';
        }
        else
        {
            // dados do arquivo
            $this->dadosArquivo();

            // verifica se é imagem
            if (!$this->eImagem())
            {
                $this->erro = 'Erro: Arquivo '.$this->origem.' não é uma imagem!';
            }
            else
            {
                // pega dimensões
                $this->dimensoes();

                // cria imagem para php
                $this->criaImagem();
            }
        }

    } // fim dadosImagem

    /**
     * Retorna validação da imagem
     * @param
     * @return String string com erro de mensagem ou 'OK' para imagem válida
     */
    public function valida()
    {
        return $this->erro;
    } // fim valida

    /**
     * Carrega uma nova imagem, fora do construtor
     * @param String caminho da imagem a ser carregada
     * @return void
     */
    public function carrega( $origem = '' )
    {
        $this->origem			= $origem;
        $this->dados();
    } // fim carrega

//------------------------------------------------------------------------------
// dados da imagem

    /**
     * Busca dimensões e formato real da imagem
     * @param
     * @return void
     */
    private function dimensoes()
    {
        $dimensoes 				= getimagesize( $this->origem );
        $this->largura 	 		= $dimensoes[0];
        $this->altura	 		= $dimensoes[1];
        // 1 = gif, 2 = jpeg, 3 = png, 6 = BMP
        // http://br2.php.net/manual/en/function.exif-imagetype.php
        $this->formato			= $dimensoes[2];
        $this->tamanho_html		= $dimensoes[3];
    } // fim dimensoes

    /**
     * Busca dados do arquivo
     * @param
     * @return void
     */
    private function dadosArquivo()
    {
        // imagem de origem
        $pathinfo 			= pathinfo( $this->origem );
        $this->extensao 	= strtolower( $pathinfo['extension'] );
        $this->arquivo		= $pathinfo['basename'];
        $this->diretorio	= $pathinfo['dirname'];
        $this->tamanho		= filesize( $this->origem );
    } // fim dadosArquivo

    /**
     * Verifica se o arquivo indicado é uma imagem
     * @param
     * @return Boolean true/false
     */
    private function eImagem()
    {
        // filtra extensão
        if ( !in_array( $this->extensao, $this->extensoes_validas ) )
        {
            return false;
        }
        else
        {
            return true;
        }
    } // fim validaImagem

//------------------------------------------------------------------------------
// manipulação da imagem

    /**
     * Cria objeto de imagem para manipulação no GD
     * @param
     * @return void
     */
    private function criaImagem()
    {
        switch ( $this->formato )
        {
            case 1:
                $this->img = imagecreatefromgif( $this->origem );
                $this->extensao = 'gif';
                break;
            case 2:
                $this->img = imagecreatefromjpeg( $this->origem );
                $this->extensao = 'jpg';
                break;
            case 3:
                $this->img = imagecreatefrompng( $this->origem );
                $this->extensao = 'png';
                break;
            case 6:
                $this->img = imagecreatefrombmp( $this->origem );
                $this->extensao = 'bmp';
                break;
            default:
                trigger_error( 'Arquivo inválido!', E_USER_WARNING );
                break;
        }
    } // fim criaImagem

//------------------------------------------------------------------------------
// funções para redimensionamento

    /**
     * Armazena os valores RGB para redimensionamento com fill
     * @param Valores R, G e B
     * @return Void
     */
    public function rgb( $r, $g, $b )
    {
        $this->rgb = array( $r, $g, $b );
    } // fim rgb

    /**
     * Armazena posições x e y para crop
     * @param Array valores x e y
     * @return Void
     */
    public function posicaoCrop( $x, $y )
    {
        $this->posicao_crop = array( $x, $y, $this->largura, $this->altura );
    } // fim posicao_crop

    /**
     * Redimensiona imagem
     * @param Int $nova_largura valor em pixels da nova largura da imagem
     * @param Int $nova_altura valor em pixels da nova altura da imagem
     * @param String $tipo método para redimensionamento (padrão [vazio], 'fill' [preenchimento] ou 'crop')
     * @return Boolean/void
     */
    public function redimensiona( $nova_largura = 0, $nova_altura = 0, $tipo = '' )
    {

        // seta variáveis passadas via parâmetro
        $this->nova_largura		= $nova_largura;
        $this->nova_altura		= $nova_altura;

        // verifica se passou altura ou largura como porcentagem
        // largura %
        $pos = strpos( $this->nova_largura, '%' );
        if( $pos !== false && $pos > 0 )
        {
            $porcentagem			= ( ( int ) str_replace( '%', '', $this->nova_largura ) ) / 100;
            $this->nova_largura		= round( $this->largura * $porcentagem );
        }
        // altura %
        $pos = strpos( $this->nova_altura, '%' );
        if( $pos !== false && $pos > 0 )
        {
            $porcentagem			= ( ( int ) str_replace( '%', '', $this->nova_altura ) ) / 100;
            $this->nova_altura		= $this->altura * $porcentagem;
        }

        // define se só passou nova largura ou altura
        if ( !$this->nova_largura && !$this->nova_altura )
        {
            return false;
        }
        // só passou altura
        elseif ( !$this->nova_largura )
        {
            $this->nova_largura = $this->largura / ( $this->altura/$this->nova_altura );
        }
        // só passou largura
        elseif ( !$this->nova_altura )
        {
            $this->nova_altura = $this->altura / ( $this->largura/$this->nova_largura );
        }

        // redimensiona de acordo com tipo
        switch( $tipo )
        {
            case 'crop':
                $this->resizeCrop();
                break;
            case 'fill':
                $this->resizeFill();
                break;
            default:
                $this->resize();
                break;
        }

        // atualiza dimensões da imagem
        $this->altura 	= $this->nova_altura;
        $this->largura	= $this->nova_largura;

    } // fim redimensiona

    /**
     * Redimensiona imagem, modo padrão, sem crop ou fill (distorcendo)
     * @param
     * @return void
     */
    private function resize()
    {
        // cria imagem de destino temporária
        $this->img_temp	= imagecreatetruecolor( $this->nova_largura, $this->nova_altura );

        imagecopyresampled( $this->img_temp, $this->img, 0, 0, 0, 0, $this->nova_largura, $this->nova_altura, $this->largura, $this->altura );
        $this->img	= $this->img_temp;
    } // fim resize()

    /**
     * Adiciona cor de fundo à imagem
     * @param
     * @return void
     */
    private function preencheImagem()
    {
        $corfundo = imagecolorallocate( $this->img_temp, $this->rgb[0], $this->rgb[1], $this->rgb[2] );
        imagefill( $this->img_temp, 0, 0, $corfundo );
    } // fim preencheImagem

    /**
     * Redimensiona imagem sem cropar, proporcionalmente,
     * preenchendo espaço vazio com cor rgb especificada
     * @param
     * @return void
     */
    private function resizeFill()
    {
        // cria imagem de destino temporária
        $this->img_temp	= imagecreatetruecolor( $this->nova_largura, $this->nova_altura );

        // adiciona cor de fundo à nova imagem
        $this->preencheImagem();

        // salva variáveis para centralização
        $dif_y = $this->nova_altura;
        $dif_x = $this->nova_largura;

        // verifica altura e largura
        if ( $this->largura > $this->altura )
        {
            $this->nova_altura	= ( ( $this->altura * $this->nova_largura ) / $this->largura );
        }
        elseif ( $this->largura <= $this->altura )
        {
            $this->nova_largura	= ( ( $this->largura * $this->nova_altura ) / $this->altura );
        }  // fim do if verifica altura largura

        // copia com o novo tamanho, centralizando
        $dif_x = ( $dif_x - $this->nova_largura ) / 2;
        $dif_y = ( $dif_y - $this->nova_altura ) / 2;
        imagecopyresampled( $this->img_temp, $this->img, $dif_x, $dif_y, 0, 0, $this->nova_largura, $this->nova_altura, $this->largura, $this->altura );
        $this->img	= $this->img_temp;
    } // fim resizeFill()

    /**
     * Calcula a posição do crop
     * Os índices 0 e 1 correspondem à posição x e y do crop na imagem
     * Os índices 2 e 3 correspondem ao tamanho do crop
     * @param
     * @return void
     */
    private function calculaPosicaoCrop()
    {
        // média altura/largura
        $hm	= $this->altura / $this->nova_altura;
        $wm	= $this->largura / $this->nova_largura;

        // 50% para cálculo do crop
        $h_height = $this->nova_altura / 2;
        $h_width  = $this->nova_largura / 2;

        // calcula novas largura e altura
        if( !is_array( $this->posicao_crop ) )
        {
            if ( $wm > $hm )
            {
                $this->posicao_crop[2] 	= $this->largura / $hm;
                $this->posicao_crop[3]  = $this->nova_altura;
                $this->posicao_crop[0]  = ( $this->posicao_crop[2] / 2 ) - $h_width;
                $this->posicao_crop[1]	= 0;
            }
            // largura <= altura
            elseif ( ( $wm <= $hm ) )
            {
                $this->posicao_crop[2] 	= $this->nova_largura;
                $this->posicao_crop[3]  = $this->altura / $wm;
                $this->posicao_crop[0]  = 0;
                $this->posicao_crop[1]	= ( $this->posicao_crop[3] / 2 ) - $h_height;
            }
        }
    } // fim calculaPosicaoCrop

    /**
     * Redimensiona imagem, cropando para encaixar no novo tamanho, sem sobras
     * baseado no script original de Noah Winecoff
     * http://www.findmotive.com/2006/12/13/php-crop-image/
     * atualizado para receber o posicionamento X e Y do crop na imagem
     * @return void
     */
    private function resizeCrop()
    {
        // calcula posicionamento do crop
        $this->calculaPosicaoCrop();

        // cria imagem de destino temporária
        $this->img_temp	= imagecreatetruecolor( $this->nova_largura, $this->nova_altura );

        // adiciona cor de fundo à nova imagem
        $this->preencheImagem();

        imagecopyresampled( $this->img_temp, $this->img, -$this->posicao_crop[0], -$this->posicao_crop[1], 0, 0, $this->posicao_crop[2], $this->posicao_crop[3], $this->largura, $this->altura );

        $this->img	= $this->img_temp;
    } // fim resizeCrop

//------------------------------------------------------------------------------
// funções de manipulação da imagem

    /**
     * flipa/inverte imagem
     * baseado no script original de Noah Winecoff
     * http://www.php.net/manual/en/ref.image.php#62029
     * @param String $tipo tipo de espelhamento: h - horizontal, v - vertical
     * @return void
     */
    public function flip( $tipo = 'h' )
    {
        $w = imagesx( $this->img );
        $h = imagesy( $this->img );

        $this->img_temp = imagecreatetruecolor( $w, $h );

        // vertical
        if ( 'v' == $tipo )
        {
            for ( $y = 0; $y < $h; $y++ )
            {
                imagecopy( $this->img_temp, $this->img, 0, $y, 0, $h - $y - 1, $w, 1 );
            }
        }

        // horizontal
        if ( 'h' == $tipo )
        {
            for ( $x = 0; $x < $w; $x++ )
            {
                imagecopy( $this->img_temp, $this->img, $x, 0, $w - $x - 1, 0, 1, $h );
            }
        }

        $this->img	= $this->img_temp;

    } // fim flip

    /**
     * gira imagem
     * @param Int $graus grau para giro
     * @param Array $rgb cor RGB para preenchimento
     * @return void
     */
    public function girar( $graus, $rgb = array( 255,255,255 ) )
    {
        $corfundo	= imagecolorallocate( $this->img, $rgb[0], $rgb[1], $rgb[2] );
        $this->img	= imagerotate( $this->img, $graus, $corfundo );
    } // fim girar

    /**
     * adiciona texto à imagem
     * @param String $texto texto a ser inserido
     * @param Int $tamanho tamanho da fonte
     * @param Int $x posição x do texto na imagem
     * @param Int $y posição y do texto na imagem
     * @param Array $rgb cor do texto
     * @param Boolean $truetype true para utilizar fonte truetype, false para fonte do sistema
     * @param String $fonte nome da fonte truetype a ser utilizada
     * @return void
     */
    public function legenda( $texto, $tamanho = 10, $x = 0, $y = 0, $rgb = array( 255,255,255 ), $truetype = false, $fonte = '' )
    {
        $cortexto = imagecolorallocate( $this->img, $rgb[0], $rgb[1], $rgb[2] );

        // truetype ou fonte do sistema?
        if ( $truetype === true )
        {
            imagettftext( $this->img, $tamanho, 0, $x, $y, $cortexto, $fonte, $texto );
        }
        else
        {
            imagestring( $this->img, $tamanho, $x, $y, $texto, $cortexto );
        }
    } // fim legenda

    /**
     * adiciona imagem de marca d'água
     * @param String $imagem caminho da imagem de marca d'água
     * @param Int $x posição x da marca na imagem
     * @param Int $y posição y da marca na imagem
     * @return Boolean true/false dependendo do resultado da operação
     * @param Int $alfa valor para transparência (0-100)
    -> se utilizar alfa, a função imagecopymerge não preserva
    -> o alfa nativo do PNG
     */
    public function marca( $imagem, $x = 0, $y = 0, $alfa = 100 )
    {
        // cria imagem temporária para merge
        if ( $imagem ) {
            $pathinfo = pathinfo( $imagem );
            switch( strtolower( $pathinfo['extension'] ) )
            {
                case 'jpg':
                case 'jpeg':
                    $marcadagua = imagecreatefromjpeg( $imagem );
                    break;
                case 'png':
                    $marcadagua = imagecreatefrompng( $imagem );
                    break;
                case 'gif':
                    $marcadagua = imagecreatefromgif( $imagem );
                    break;
                case 'bmp':
                    $marcadagua = imagecreatefrombmp( $imagem );
                    break;
                default:
                    $this->erro = 'Arquivo de marca d\'água inválido.';
                    return false;
            }
        }
        else
        {
            return false;
        }
        // dimensões
        $marca_w	= imagesx( $marcadagua );
        $marca_h	= imagesy( $marcadagua );
        // retorna imagens com marca d'água
        if ( is_numeric( $alfa ) && ( ( $alfa > 0 ) && ( $alfa < 100 ) ) ) {
            imagecopymerge( $this->img, $marcadagua, $x, $y, 0, 0, $marca_w, $marca_h, $alfa );
        } else {
            imagecopy( $this->img, $marcadagua, $x, $y, 0, 0, $marca_w, $marca_h );
        }
        return true;
    } // fim marca

    /**
     * adiciona imagem de marca d'água, com valores fixos
     * ex: topo_esquerda, topo_direita etc.
     * Implementação original por Giolvani <inavloig@gmail.com>
     * @param String $imagem caminho da imagem de marca d'água
     * @param String $posicao posição/orientação fixa da marca d'água
     *        [topo, meio, baixo] + [esquerda, centro, direita]
     * @param Int $alfa valor para transparência (0-100)
     * @return void
     */
    public function marcaFixa( $imagem, $posicao, $alfa = 100 )
    {

        // dimensões da marca d'água
        list( $marca_w, $marca_h ) = getimagesize( $imagem );

        // define X e Y para posicionamento
        switch( $posicao )
        {
            case 'topo_esquerda':
                $x = 0;
                $y = 0;
                break;
            case 'topo_centro':
                $x = ( $this->largura - $marca_w ) / 2;
                $y = 0;
                break;
            case 'topo_direita':
                $x = $this->largura - $marca_w;
                $y = 0;
                break;
            case 'meio_esquerda':
                $x = 0;
                $y = ( $this->altura / 2 ) - ( $marca_h / 2 );
                break;
            case 'meio_centro':
                $x = ( $this->largura - $marca_w ) / 2;
                $y = ( $this->altura / 2 ) - ( $marca_h / 2 );
                break;
            case 'meio_direita':
                $x = $this->largura - $marca_w;
                $y = ( $this->altura / 2) - ( $marca_h / 2 );
                break;
            case 'baixo_esquerda':
                $x = 0;
                $y = $this->altura - $marca_h;
                break;
            case 'baixo_centro':
                $x = ( $this->largura - $marca_w ) / 2;
                $y = $this->altura - $marca_h;
                break;
            case 'baixo_direita':
                $x = $this->largura - $marca_w;
                $y = $this->altura - $marca_h;
                break;
            default:
                return false;
                break;
        } // end switch posicao

        // cria marca
        $this->marca( $imagem, $x, $y, $alfa );

    } // fim marcaFixa


//------------------------------------------------------------------------------
// gera imagem de saída

    /**
     * retorna saída para tela ou arquivo
     * @param String $destino caminho e nome do arquivo a serem criados
     * @param Int $qualidade qualidade da imagem no caso de JPEG (0-100)
     * @return void
     */
    public function grava( $destino='', $qualidade = 100 )
    {
        // dados do arquivo de destino
        if ( $destino )
        {
            $pathinfo 			= pathinfo( $destino );
            $dir_destino		= $pathinfo['dirname'];
            $extensao_destino 	= strtolower( $pathinfo['extension'] );

            // valida diretório
            if ( !is_dir( $dir_destino ) )
            {
                $this->erro	= 'Diretório de destino inválido ou inexistente';
                return false;
            }

        }

        // valida extensão de destino
        if ( !isset( $extensao_destino ) )
        {
            $extensao_destino = $this->extensao;
        }
        else
        {
            if ( !in_array( $extensao_destino, $this->extensoes_validas ) )
            {
                $this->erro = 'Extensão inválida para o arquivo de destino';
                return false;
            }
        }

        switch( $extensao_destino )
        {
            case 'jpg':
            case 'jpeg':
            case 'bmp':
                if ( $destino )
                {
                    imagejpeg( $this->img, $destino, $qualidade );
                }
                else
                {
                    header( "Content-type: image/jpeg" );
                    imagejpeg( $this->img, NULL, $qualidade );
                    imagedestroy( $this->img );
                    exit;
                }
                break;
            case 'png':
                if ( $destino )
                {
                    imagepng( $this->img, $destino );
                }
                else
                {
                    header( "Content-type: image/png" );
                    imagepng( $this->img );
                    imagedestroy( $this->img );
                    exit;
                }
                break;
            case 'gif':
                if ( $destino )
                {
                    imagegif( $this->img, $destino );
                }
                else
                {
                    header( "Content-type: image/gif" );
                    imagegif( $this->img );
                    imagedestroy( $this->img );
                    exit;
                }
                break;
            default:
                return false;
                break;
        }

    } // fim grava

//------------------------------------------------------------------------------
// fim da classe
}

function imagecreatefrombmp($filename) {
    //Ouverture du fichier en mode binaire
    if (! $f1 = fopen($filename,"rb")) return FALSE;

    //1 : Chargement des ent?tes FICHIER
    $FILE = unpack("vfile_type/Vfile_size/Vreserved/Vbitmap_offset", fread($f1,14));
    if ($FILE['file_type'] != 19778) return FALSE;

    //2 : Chargement des ent?tes BMP
    $BMP = unpack('Vheader_size/Vwidth/Vheight/vplanes/vbits_per_pixel'.
        '/Vcompression/Vsize_bitmap/Vhoriz_resolution'.
        '/Vvert_resolution/Vcolors_used/Vcolors_important', fread($f1,40));
    $BMP['colors'] = pow(2,$BMP['bits_per_pixel']);
    if ($BMP['size_bitmap'] == 0) $BMP['size_bitmap'] = $FILE['file_size'] - $FILE['bitmap_offset'];
    $BMP['bytes_per_pixel'] = $BMP['bits_per_pixel']/8;
    $BMP['bytes_per_pixel2'] = ceil($BMP['bytes_per_pixel']);
    $BMP['decal'] = ($BMP['width']*$BMP['bytes_per_pixel']/4);
    $BMP['decal'] -= floor($BMP['width']*$BMP['bytes_per_pixel']/4);
    $BMP['decal'] = 4-(4*$BMP['decal']);
    if ($BMP['decal'] == 4) $BMP['decal'] = 0;

    //3 : Chargement des couleurs de la palette
    $PALETTE = array();
    if ($BMP['colors'] < 16777216)
    {
        $PALETTE = unpack('V'.$BMP['colors'], fread($f1,$BMP['colors']*4));
    }

    //4 : Cr?ation de l'image
    $IMG = fread($f1,$BMP['size_bitmap']);
    $VIDE = chr(0);

    $res = imagecreatetruecolor($BMP['width'],$BMP['height']);
    $P = 0;
    $Y = $BMP['height']-1;
    while ($Y >= 0)
    {
        $X=0;
        while ($X < $BMP['width'])
        {
            if ($BMP['bits_per_pixel'] == 24)
                $COLOR = @unpack("V",substr($IMG,$P,3).$VIDE);
            elseif ($BMP['bits_per_pixel'] == 16)
            {
                $COLOR = @unpack("n",substr($IMG,$P,2));
                $COLOR[1] = $PALETTE[$COLOR[1]+1];
            }
            elseif ($BMP['bits_per_pixel'] == 8)
            {
                $COLOR = @unpack("n",$VIDE.substr($IMG,$P,1));
                $COLOR[1] = $PALETTE[$COLOR[1]+1];
            }
            elseif ($BMP['bits_per_pixel'] == 4)
            {
                $COLOR = @unpack("n",$VIDE.substr($IMG,floor($P),1));
                if (($P*2)%2 == 0) $COLOR[1] = ($COLOR[1] >> 4) ; else $COLOR[1] = ($COLOR[1] & 0x0F);
                $COLOR[1] = $PALETTE[$COLOR[1]+1];
            }
            elseif ($BMP['bits_per_pixel'] == 1)
            {
                $COLOR = @unpack("n",$VIDE.substr($IMG,floor($P),1));
                if     (($P*8)%8 == 0) $COLOR[1] =  $COLOR[1]        >>7;
                elseif (($P*8)%8 == 1) $COLOR[1] = ($COLOR[1] & 0x40)>>6;
                elseif (($P*8)%8 == 2) $COLOR[1] = ($COLOR[1] & 0x20)>>5;
                elseif (($P*8)%8 == 3) $COLOR[1] = ($COLOR[1] & 0x10)>>4;
                elseif (($P*8)%8 == 4) $COLOR[1] = ($COLOR[1] & 0x8)>>3;
                elseif (($P*8)%8 == 5) $COLOR[1] = ($COLOR[1] & 0x4)>>2;
                elseif (($P*8)%8 == 6) $COLOR[1] = ($COLOR[1] & 0x2)>>1;
                elseif (($P*8)%8 == 7) $COLOR[1] = ($COLOR[1] & 0x1);
                $COLOR[1] = $PALETTE[$COLOR[1]+1];
            }
            else
                return FALSE;
            imagesetpixel($res,$X,$Y,$COLOR[1]);
            $X++;
            $P += $BMP['bytes_per_pixel'];
        }
        $Y--;
        $P+=$BMP['decal'];
    }

    //Fermeture du fichier
    fclose($f1);

    return $res;

}



/* CREDITOS END  hi@daviferreira.com @davitferreira */
class myFiles extends Conexao {


    public function removerFile($idfile) {
        $busca_file = $this->myexec("SELECT * from `arquivos` where id_arquivos = '$idfile'");
        $busca_file_n = mysql_num_rows($busca_file);
        if($busca_file_n == 0)
            return "Falha, arquivo não encontrado";
        while($ln_f = mysql_fetch_array($busca_file)) {

            if(!unlink($_SERVER['DOCUMENT_ROOT']."/".$ln_f[path_arquivos])) {
                echo "Falha, Arquivo de path ".$_SERVER['DOCUMENT_ROOT']."/$ln_f[path_arquivos] não removido ";
            } else {
                if(!$this->exeQuery("DELETE from `arquivos` where id_arquivos = '$idfile'"))
                    return "Falha ao deletar do banco";
                else
                    return "Sucesso";
            }

        }
    }

    public function removerFileComplete($idfile) {
        $busca_file = $this->myexec("SELECT * from `arquivos` where id_arquivos = '$idfile'");
        $busca_file_n = mysql_num_rows($busca_file);
        if($busca_file_n == 0)
            return "Falha, arquivo não encontrado";
        while($ln_f = mysql_fetch_array($busca_file)) {

            if(!unlink("../".$ln_f[path_arquivos])) {
                echo "Falha, Arquivo de path $ln_f[path_arquivos] não removido ";
            } else {
                if(!$this->exeQuery("DELETE from `arquivos` where id_arquivos = '$idfile'"))
                    return "Falha ao deletar do banco";
                else
                    return "Sucesso";
            }

        }
    }

    public function getArray($array) {

        if($array == 'imagens')
            return array("jpeg","jpg","JPEG","JPG","png","PNG");

        if($array == 'compressed')
            return array("zip","ZIP");

        if($array == 'pdf')
            return array("PDF","pdf");

        if($array == 'text')
            return array("zip","ZIP");

    }


}

#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### OBJETOS
#---------------------------------------------------------------------------------------------------------------------------------------------------#

$conexao = new Conexao();
$lang = new Language();
$acesso = new Acessos();
$t = new Tools();
$file = new myFiles();


#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### VARS UNIVERSAIS
#---------------------------------------------------------------------------------------------------------------------------------------------------#



$par_start_path = "//".$_SERVER['SERVER_NAME']."/";
$par_start_path_sistema = "//".$_SERVER['SERVER_NAME']."/$par_start_folder_sistema/";
$arquivo_estamos = end(explode("/", $_SERVER['PHP_SELF']));

#---------------------------------------------------------------------------------------------------------------------------------------------------#
############### ARRAYS UNIVERSAIS
#---------------------------------------------------------------------------------------------------------------------------------------------------#
$array_img = array("jpeg","jpg","JPEG","JPG","png","PNG");
$array_compressed =  array("zip","ZIP");
$array_pdf =  array("PDF","pdf");



#### DEFININDO CONEXAO


if(empty($_SESSION[usuario_sys])) {
    $conexao->DefinirVarSessions($usuario_sys,$password_sys,$link_sys,$userftp_sys,$senhaftp_sys,$linkftp_sys);
} else {
    $par_start_timeout = $conexao->getPar(5);
}
if(empty($par_start_timeout))
    $par_start_timeout = 5000;


if(!empty($_GET[errors])) {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
}



