<?php

class Login {
    private $login;
    private $password;
    private $idUser;
    private $statusLog;
    private $name;
    private $fields;

    public function __construct($login = NULL, $password = NULL){
        $this->login = $login;
        $this->password = $password;

        $res = $this->checkUser();

        if($res){
            $this->createIdSession();
        }else{
            $this->statusLog = array("responseText"=>"no-user");
        }
    }

    protected function createIdSession(){
        $sessionId = session_id();
        $_SESSION['idUser'] = $this->idUser;
        $_SESSION['usu_name'] = $this->name;

        $con = new Connect();
        $con->query("update usuarios set usu_session_id = :IDSESSION where id_usuarios = :IDUSER",array(
            ":IDSESSION" => $sessionId,
            ":IDUSER" => $this->idUser
        ));

        $this->statusLog = array("responseText"=>"success");
    }

    protected function checkUser(){
        $con = new Connect();
        $res = $con->select("select * from usuarios, parametros_niveis where usu_nivel = id_niveis and usu_login = :LOGIN and usu_senha = :PASSWORD and usu_status = :STATUS", array(
            ":LOGIN" => $this->login,
            ":PASSWORD" => md5($this->password),
            ":STATUS" => "ATIVADO"
        ));

        if(count($res) > 0){
            $this->name = $res[0]['usu_nome'];
            return true;
        }
    }

    public static function isLogin(){
        if(empty($_SESSION['id_usuarios']))
            return false;


        $con = new Connect();
        $res = $con->select("select id_usuarios from usuarios where id_usuarios = :IDUSER and  usu_session_id = :ACCESS and usu_status = :STATUS", array(
            ":ACCESS" => session_id(),
            ":STATUS" => "ATIVADO",
            ":IDUSER" => $_SESSION['id_usuarios']
        ));


        if(count($res) > 0){
            return "LOGADO";
        }else
            return "NAO LOGADO";

    }

    public static function logOut(){
        $con = new Connect();
        $idUser = $_SESSION['idUser'];
        $con->query("update usuarios set usu_session_id = null where id_usuarios = :IDUSER",array(
            ":IDUSER" => $idUser
        ));
        unset($_SESSION['idUser']);
    }

    public function __toString()
    {
        return json_encode($this->statusLog);
    }

    public static function isLoginPluto()
    {
        $conn = new Connect();
        $res = $conn->select("SELECT * from usuarios where usu_login = :V1 and usu_senha = :V2 and usu_status = 'ATIVADO'", array(
           ":V1" => $_COOKIE['usu_login'],
           ":V2" => $_COOKIE['usu_senha']
        ));

        if(count($res) > 0)
            return true;

    }

    public static function isAcess($idScrren)
    {
        $conn = new Connect();
        $res = $conn->select("SELECT * from parametros_permissoes where codnivel = :V1 and codfuncao = :V2", array(
            ":V1" => $_COOKIE['usu_nivel'],
            ":V2" => $idScrren
        ));

        if(count($res) > 0)
            return true;
    }

}